/* HOUSEHOLD TRAVEL MODEL*/
mata
/* DIMENSIONS*/
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050
//Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection
*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length
Time_t = 1992..2050
/*Length of history
*History_length = length(History_t)*/
History_length = Te - Ts+1
HL = History_length
Reg_length=12
Fleet_projection = 2021..2050
VKT_t = 2001..2050
VKT_time_length = length(VKT_t)
VKT_projection = 2021..2050
TL_fleet = length(Fleet_t)
PL_fleet = length(Fleet_projection)
TL_vkt = length(VKT_t)
fleet_input_t = 2000..2020
IL_fleet = cols(fleet_input_t)
PL_fleet = length(Fleet_projection)+1 /*Fleet Projection length (PL)*/
veh_ages_l = (cols(lpv_input))/*Vehicle type and age dimensions*/
veh_ages_str=0..44
	veh_ages_n=length(veh_ages_str)
VKT_input_t = 2001..2020
IL_vkt = length(VKT_input_t)
PL_vkt = length(VKT_projection)
IL_fiscal = 29 /*This is upto 2020*/


/*Length of projection*/
/*Projection_length = length(Projection_t)*/
Projection_length = Pe - Ps + 1

Fleet_projection = 2021..2050
VKT_projection = 2021..2050
/*Length of historical data series*/
History_length = Te - Ts+1
HL = History_length
/*Set series length, history plus projection*/
Time_length = Pe - Ts + 1
TL = Time_length
Time_t = 1992..2050
Fleet_t = 2000..2050
Fleet_projection = Pe-Ps

VKT_t = 2001..2050
Fleet_time_length = length(Fleet_t)
VKT_time_length = length(VKT_t)
fleet_input_t = 2000..2020
fleet_input_t_length = length(fleet_input_t)
VKT_tot_input_t = 2001..2020
VKT_tot_input_length = length(VKT_tot_input_t)
VKT_input_t = 2000..2020
VKT_input_t_length = length(VKT_input_t)
VKT_projection_length = length(VKT_projection)
PL = length(VKT_projection)
geo2model = (1,	2,	3,	4,	6,	7,	8,	10,	11,	12,	5,	9)

/* ASSUMPTIONS/PARAMETERS*/

/* Input the data files include data inputs on propensities of age groups*/
/* (<15,15-24,25-34,35-44,45-54,55-64,65+) to: */
/* (a)travel by public transport (pt_age_dist) */
/* (b)drive a vehicle (vkt_age_dist) */
/* (c)be a passenger in a vehicle (pass_age_dist) */
/* The last of these is not used because we dont yet have sufficient data on */
/* how passenger kilometres translates to occupancy by age group. */

/* The following collates the input assumptions from the main model file – */
/* these are generally not used any more because they are supplanted by the */
/* mode choice model: */
reg_vkt_distr_growth = (nor_vkt_dist_growth,akl_vkt_dist_growth,wai_vkt_dist_growth,bop_vkt_dist_growth,tar_vkt_dist_growth,man_vkt_dist_growth,wel_vkt_dist_growth,can_vkt_dist_growth,otg_vkt_dist_growth,sth_vkt_dist_growth,gis_vkt_dist_growth,usi_vkt_dist_growth)
reg_occupancy_growth = (nor_occ_growth,akl_occ_growth,wai_occ_growth,bop_occ_growth,tar_occ_growth,man_occ_growth,wel_occ_growth,can_occ_growth,otg_occ_growth,sth_occ_growth,gis_occ_growth,usi_occ_growth) /* current assumed to remain constant*/
reg_pt_km_per_pass_growth = (nor_pt_km_growth,akl_pt_km_growth,wai_pt_km_growth,bop_pt_km_growth,tar_pt_km_growth,man_pt_km_growth,wel_pt_km_growth,can_pt_km_growth,otg_pt_km_growth,sth_pt_km_growth,gis_pt_km_growth,usi_pt_km_growth) /* current assumed to remain constant*/
reg_pt_passengers_growth = (nor_pt_pas_growth,akl_pt_pas_growth,wai_pt_pas_growth,bop_pt_pas_growth,tar_pt_pas_growth,man_pt_pas_growth,wel_pt_pas_growth,can_pt_pas_growth,otg_pt_pas_growth,sth_pt_pas_growth,gis_pt_pas_growth,usi_pt_pas_growth)/* current assumed to remain constant (needs to be considered on a per capita basis*/
reg_cyc_growth = (nor_cyc_growth,akl_cyc_growth,wai_cyc_growth,bop_cyc_growth,tar_cyc_growth,man_cyc_growth,wel_cyc_growth,can_cyc_growth,otg_cyc_growth,sth_cyc_growth,gis_cyc_growth,usi_cyc_growth)
reg_walk_growth = (nor_walk_growth,akl_walk_growth,wai_walk_growth,bop_walk_growth,tar_walk_growth,man_walk_growth,wel_walk_growth,can_walk_growth,otg_walk_growth,sth_walk_growth,gis_walk_growth,usi_walk_growth)

/* INITIALISE*/
reg_vkt_distr_proj = (reg_vkt_input[.,1..12]\J(PL,Reg_length,0))
reg_pt_km_per_pass_proj = (reg_km_per_pass_input\J(VKT_projection_length,Reg_length,0)) 
reg_pv_occupancy_proj = (reg_occupancy_input[.,1..12]\J(VKT_projection_length,Reg_length,0))  
reg_pt_passengers_proj = (reg_pt_passenger_input\J(PL_vkt+9,Reg_length,0))  
reg_pt_passkm_proj = (reg_pt_passkm_input\J(PL_vkt+9,Reg_length,0))
pop_by_reg_growth = J(Time_length,Reg_length,0)
pop_by_reg_growth[2..rows(pop_by_reg_growth),.] = diff(pop_by_reg):/(pop_by_reg[1..rows(pop_by_reg)-1,.])
d_reg_pt_passengers_proj = J(41,Reg_length,0)
reg_cyc_proj = (reg_cyc_input\J(VKT_projection_length,Reg_length,0))
reg_walk_proj = (reg_walk_input\J(VKT_projection_length,Reg_length,0))


/* INITIAL REGIONAL PRIVATE VEHICLE VKT & PASSENGER KM*/
/* (i) Projected regional distribution (relative to national average)*/
for (i=VKT_input_t_length;i<=Fleet_time_length;i++){
    reg_vkt_distr_proj[i,.] = reg_vkt_distr_proj[i-1,.]:*reg_vkt_distr_growth
}

/** (ii)Projected VKT = (VKT/VEH)(j) x VEH(j) + a vkt/employment projection and the two are*/
/** combined*/
reg_vkt_proj_by_veh = reg_vkt_distr_proj[2..rows(reg_vkt_distr_proj),.]:*J(1,12, lite_ave_vkt_per_veh):*veh_reg[10..rows(veh_reg),.]
ln_reg_vkt_emp_constant = 9.64861810262
ln_reg_vkt_emp_fixed = (-0.047318	,-0.103019	,-0.189724	,-0.018891	,0.111692	,0.186286	,0.126534	,-0.011515	,-0.079808	,-0.014471	,0.230678	,-0.190444)
ln_reg_vkt_emp_fixed = J(TL,1, ln_reg_vkt_emp_fixed) 
ln_reg_vkt_emp = ln_reg_vkt_emp_constant :+ ln_reg_vkt_emp_fixed + ((-0.8):*((1:-reg_unemployment_fcast_rate)- (1:-J(TL,1, reg_lr_unemployment_rate))))
reg_vkt_emp = exp(ln_reg_vkt_emp) /*vkt ratio to employment*/
reg_vkt_proj_by_emp = reg_vkt_emp:*reg_employment
reg_vkt_proj = (reg_vkt_proj_by_veh + reg_vkt_proj_by_emp[10..rows(reg_vkt_proj_by_emp),.]):/2
drive_dist_rt_modelorder = J(j_t,j_r,0)

for (i = 1; i<=12; i++) {
drive_dist_rt_modelorder[.,i] = drive_dist_rt[(geo2model[i]-1)*j_t+1..geo2model[i]*j_t]
}

/**RLTDM style*/
reg_vkt_proj[1..VKT_tot_input_length,.] = reg_vkt_mot
for (i = 1;i<=PL_vkt;i++){
reg_vkt_proj[VKT_tot_input_length+i,.] = (drive_dist_rt_modelorder[TL_fiscal-PL_vkt+i,.]:/drive_dist_rt_modelorder[TL_fiscal-PL_vkt+i-1,.]):*reg_vkt_proj[VKT_tot_input_length+i-1,.]
}


/*Here is the data published by MoT plus an estimate for pre 2006*/
est_lite_vkt_tot = (31729590425.17,31889762295.45,32990059438.93,31561809927.04,32471202721.75,32646566138.65,32124985504.49,31638923626.75,33286319893.06,33764042809.65,34651954694.68,35578887403.69,36274699381.07,36581814891.94,37033000000.00,37602000000.00,37112000000.00,37269000000.00,37210000000.00,36918000000.00,37208000000.00,37309000000.00  ,38073700000.00  ,39373750000.00)
sum_reg_vkt_proj = rowsum(reg_vkt_proj)
reg_vkt_proj_growth = diff(sum_reg_vkt_proj):/sum_reg_vkt_proj[1..rows(sum_reg_vkt_proj)-1]
vkt_tot = (est_lite_vkt_tot'\J(35,1,0))
for (i=24;i<=TL;i++){
    vkt_tot[i] = vkt_tot[i-1]:*(1+reg_vkt_proj_growth[i-10])
}
reg_vkt_proj_shr = reg_vkt_proj:/J(1,12, sum_reg_vkt_proj)
reg_vkt_proj = reg_vkt_proj_shr:*J(1,12, vkt_tot[10..rows(vkt_tot),1])


/** (iii) Projected occupancy rates*/
passenger_journeys_rt=J(j_t,j_r,0)
drive_journeys_rt=J(j_t,j_r,0)
pt_dist_rt_re = J(j_t,j_r,0)

passenger_journeys_re = rowshape(passenger_journeys_hrt',72)'
drive_journeys_re = rowshape(drive_journeys_hrt',72)'
	for (i = 1; i<=12; i++) { 
passenger_journeys_rt[.,i] = rowsum(passenger_journeys_re[.,(i-1)*j_h+1..i*j_h])
drive_journeys_rt[.,i] = rowsum(drive_journeys_re[.,(i-1)*j_h+1..i*j_h])
	}
pt_dist_rt_re = rowshape(pt_dist_rt',12)'

/*
for (j=1; j<=j_t; j++){
	for (i = 1; i<=12; i++) { 
		passenger_journeys_rt[j,i] = colsum(passenger_journeys_hrt[(j-1)*j_r*j_h+(i-1)*j_h+1..(j-1)*j_r*j_h+(i-1)*j_h+j_h])
		drive_journeys_rt[j,i] = colsum(drive_journeys_hrt[(j-1)*j_r*j_h+(i-1)*j_h+1..(j-1)*j_r*j_h+(i-1)*j_h+j_h])
pt_dist_rt_re[j,i] = colsum(pt_dist_rt[(i-1)*j_t+1..(i)*j_t])

}
}
*/
pv_occupancy_hrt = 1:+(passenger_journeys_hrt:/drive_journeys_hrt)
pv_occupancy_rt = 1:+(passenger_journeys_rt:/drive_journeys_rt)
pv_occupancy_t = 1:+(rowsum(passenger_journeys_hrt):/rowsum(drive_journeys_hrt))
/* Old style projection*/
for (i=12;i<=42;i++){
    reg_pv_occupancy_proj[i,.] = reg_pv_occupancy_proj[i-1,.]:*reg_occupancy_growth
}
/*Replaced by RLTDM style*/
/*reg_pv_occupancy_proj = pv_occupancy_rt[TL_fiscal-TL_vkt..rows(pv_occupancy_rt),.]
reg_pv_passkm_proj = reg_pv_occupancy_proj[2..rows(reg_pv_occupancy_proj),.]:*reg_vkt_proj*/
reg_pv_occupancy_proj = pv_occupancy_rt
reg_vkt_proj_re=(J(9,12,0)\reg_vkt_proj)
reg_pv_passkm_proj = reg_pv_occupancy_proj:*reg_vkt_proj_re


/* INITIAL PROJECTED REGIONAL PT PASSENGER KM [MIGHT BE ABLE TO DELETE*/
/** [i] Project km/passenger*/
/*From mode choice model*/
bus_journeys_rt = J(TL,12*6,0)
train_journeys_rt = J(TL,12*6,0)
for (i = 1; i<=12; i++) { 
	for (j=1; j<=6; j++){
	bus_journeys_rt[.,(i-1)*6+j] = bus_journeys_hrt[(i-1)*6*12+(j-1)*TL+1..(i-1)*6*12+j*TL]
	train_journeys_rt[.,(i-1)*6+j] = train_journeys_hrt[(i-1)*6*12+(j-1)*TL+1..(i-1)*6*12+j*TL]
	}
}

pt_journeys_rt_sum = J(59,12,0)
pt_dist_rt = bus_dist_rt + train_dist_rt
pt_journeys_rt = bus_journeys_rt + train_journeys_rt
for (i=1;i<=12;i++){
    pt_journeys_rt_sum[.,i] = rowsum(pt_journeys_rt[.,(i-1)*j_h+1..i*j_h])
}
pt_dist_per_journey_rt = pt_dist_rt_re:/pt_journeys_rt_sum

bus_journeys_rt_modelorder = J(TL,12,0)
train_journeys_rt_modelorder = J(TL,12,0)
pt_dist_rt_modelorder = J(TL,12,0)
pt_journeys_rt_modelorder = J(TL,12,0)
pt_dist_per_journey_rt_mo = J(TL,12,0)

bus_journeys_rt_sum = J(TL,12,0)
train_journeys_rt_sum = J(TL,12,0)
pt_dist_rt_sum = J(TL,12,0)
pt_journeys_rt_sum = J(TL,12,0)
for (i=1;i<=12;i++){
    bus_journeys_rt_sum[.,i] = rowsum(bus_journeys_rt[.,(i-1)*j_h+1..i*j_h])
    train_journeys_rt_sum[.,i] = rowsum(train_journeys_rt[.,(i-1)*j_h+1..i*j_h])
	pt_dist_rt_sum[.,i] = pt_dist_rt[(i-1)*j_t+1..i*j_t]
    pt_journeys_rt_sum[.,i] = rowsum(pt_journeys_rt[.,(i-1)*j_h+1..i*j_h])
}


for (i=1;i<=12;i++){
bus_journeys_rt_modelorder[.,i] = bus_journeys_rt_sum[.,geo2model[i]]
train_journeys_rt_modelorder[.,i] = train_journeys_rt_sum[.,geo2model[i]]
pt_dist_rt_modelorder[.,i] = pt_dist_rt_sum[.,geo2model[i]]
pt_journeys_rt_modelorder[.,i] = pt_journeys_rt_sum[.,geo2model[i]]
pt_dist_per_journey_rt_mo[.,i] = pt_dist_per_journey_rt[.,geo2model[i]]
}

pt_journeys_rt_g = (J(1,12,0)\pt_journeys_rt_modelorder[2..rows(pt_journeys_rt_modelorder),.]:/pt_journeys_rt_modelorder[1..rows(pt_journeys_rt_modelorder)-1,.])
pt_dist_per_journey_rt_g = (J(1,12,0)\pt_dist_per_journey_rt_mo[2..rows(pt_dist_per_journey_rt_mo),.]:/pt_dist_per_journey_rt_mo[1..rows(pt_dist_per_journey_rt_mo)-1,.])
reg_pt_km_per_pass_proj = pt_dist_per_journey_rt_mo
/*RLTDM styles*/
/*
for (i = 1;i<=PL_vkt;i++){
reg_pt_passengers_proj[VKT_tot_input_length+i,.] = pt_journeys_rt_g[TL_fiscal-PL_vkt+i,.]:*reg_pt_passengers_proj[VKT_tot_input_length+i-1,.]
}

/** (iii) Project pt passenger kilometres*/
reg_pt_passkm_proj =  reg_pt_km_per_pass_proj[(Time_length-TL_vkt+1)..rows(reg_pt_km_per_pass_proj),.]:*reg_pt_passengers_proj
*/
for (i = 1;i<=PL_vkt+9;i++){
reg_pt_passengers_proj[VKT_tot_input_length+i,.] = pt_journeys_rt_g[TL_fiscal-PL_vkt-9+i,.]:*reg_pt_passengers_proj[VKT_tot_input_length+i-1,.]
}

/** (iii) Project pt passenger kilometres*/
/***NOTE*/

	reg_pt_passkm_proj[(Time_length-TL_vkt+1)..rows(reg_pt_km_per_pass_proj),.] =  reg_pt_km_per_pass_proj[(Time_length-TL_vkt+1)..rows(reg_pt_km_per_pass_proj),.]:*reg_pt_passengers_proj[(Time_length-TL_vkt+1)..rows(reg_pt_km_per_pass_proj),.] 
	
/*	reg_pt_passkm_proj =  reg_pt_km_per_pass_proj:*reg_pt_passengers_proj*/
/* INITIAL PROJECTED REGIONAL CYCLING AND WALKING*/
/** [i] Project walking and cycling on a per capita basis with autonomous*/
/** growth values*/
cycle_dist_rt_sum = J(59,12,0)
walk_dist_rt_sum = J(59,12,0)
for (i=1;i<=12;i++){
    cycle_dist_rt_sum[.,i] = cycle_dist_rt[(i-1)*j_t+1..i*j_t]
	walk_dist_rt_sum[.,i] = walk_dist_rt[(i-1)*j_t+1..i*j_t] 
}

cycle_dist_rt_g = cycle_dist_rt_sum[2..rows(cycle_dist_rt_sum),.]:/cycle_dist_rt_sum[1..rows(cycle_dist_rt_sum)-1,.]
walk_dist_rt_g = walk_dist_rt_sum[2..rows(cycle_dist_rt_sum),.]:/walk_dist_rt_sum[1..rows(cycle_dist_rt_sum)-1,.]

cycle_dist_rt_g_modelorder = J(58,12,0)
walk_dist_rt_g_modelorder = J(58,12,0)
for (i=1;i<=12;i++){
cycle_dist_rt_g_modelorder[.,i] = cycle_dist_rt_g[.,geo2model[i]]
walk_dist_rt_g_modelorder[.,i] = walk_dist_rt_g[.,geo2model[i]]
}

for (i=VKT_tot_input_length;i<=VKT_time_length;i++){
  reg_cyc_proj[i,.] = reg_cyc_proj[i-1,.]:*cycle_dist_rt_g_modelorder[i+(HL-VKT_tot_input_length)-1,.]:*reg_cyc_growth
  reg_walk_proj[i,.] = reg_walk_proj[i-1,.]:*walk_dist_rt_g_modelorder[i+(HL-VKT_tot_input_length)-1,.]:*reg_walk_growth
}

/* INITIAL PER CAPITA TRAVEL*/
/* OMITED */
/* ACCOMMODATE SHOCKS TO PT SUPPLY*/
/** [i] Calculate shock to PT passengers */
/** (ii) Project change in shares of passenger kilometres*/
reg_pt_passengers_proj = reg_pt_passengers_proj
d_reg_pt_passkm_proj =  reg_pt_km_per_pass_proj
reg_pt_passkm_proj = reg_pt_passkm_proj
reg_pv_passkm_proj = reg_pv_passkm_proj
/**Note*/
	reg_vkt_proj_re[9..rows(reg_vkt_proj_re),.] = reg_pv_passkm_proj[9..rows(reg_vkt_proj_re),.]:/reg_pv_occupancy_proj[9..rows(reg_vkt_proj_re),.]
reg_passkm_proj = reg_pv_passkm_proj + reg_pt_passkm_proj

/** Final per capita numbers*/
/*Note*/
reg_vkt_percap_proj = reg_vkt_proj_re:/pop_by_reg
reg_passkm_percap_proj = reg_passkm_proj:/pop_by_reg
reg_pt_passkm_percap_proj = reg_pt_passkm_proj:/pop_by_reg
reg_pv_passkm_percap_proj = reg_pv_passkm_proj:/pop_by_reg
reg_passkm_percap_by_mode = (reg_passkm_percap_proj,reg_pt_passkm_percap_proj,reg_pv_passkm_percap_proj)
reg_passkm_by_mode = (reg_passkm_proj, reg_pt_passkm_proj,reg_pv_passkm_proj)

reg_cyc_percap_proj = reg_cyc_proj:/pop_by_reg[10..59,.]
reg_walk_percap_proj = reg_walk_proj:/pop_by_reg[10..59,.]

/* NZ PASSENGER KM AND PASSENGER KM PER CAPITA*/

passkm_tot = rowsum(reg_passkm_proj)

passkm_pt_tot = rowsum(reg_pt_passkm_proj)
passkm_pv_tot = rowsum(reg_pv_passkm_proj)

tot_reg_vkt_proj = rowsum(reg_vkt_proj_re)
tot_reg_vkt_proj_growth = tot_reg_vkt_proj[2..rows(tot_reg_vkt_proj),.]:/tot_reg_vkt_proj[1..rows(tot_reg_vkt_proj)-1,.]


vkt_tot = (vkt_tot[1..21]\rowsum(reg_vkt_proj_re[22..rows(reg_vkt_proj_re),.]))
for (i=22;i<=TL;i++){
vkt_tot[i,.] = vkt_tot[i-1,.]:*tot_reg_vkt_proj_growth[i-1,1]
}

vkt_tot_growth = vkt_tot[2..rows(vkt_tot),.]:/vkt_tot[1..rows(vkt_tot)-1]:-1


vkt_per_veh = vkt_tot:/veh

passkm_percapita_tot = passkm_tot:/pop
passkm_pt_percapita_tot = passkm_pt_tot:/pop
passkm_pv_percapita_tot = passkm_pv_tot:/pop
vkt_percapita_tot = vkt_tot:/pop

passkm_per_bus = passkm_pt_tot:/bus_proj_total



/**Pad shortened output series with zeros to make them full length
passkm_tot = (J(Time_length - VKT_time_length,1,0)\passkm_tot)
passkm_pt_tot = (J(Time_length - VKT_time_length,1,0)\passkm_pt_tot)
reg_pv_passkm_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_pv_passkm_proj)
reg_pt_passkm_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_pt_passkm_proj)
reg_pv_passkm_percap_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_pv_passkm_percap_proj)
reg_pt_passkm_percap_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_pt_passkm_percap_proj)
reg_pt_passengers_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_pt_passengers_proj)
cyc_tot = (J(Time_length - VKT_time_length,1,0)\cyc_tot)
walk_tot = (J(Time_length - VKT_time_length,1,0)\walk_tot)
reg_cyc_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_cyc_proj)
reg_walk_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_walk_proj)

*/
reg_vkt_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_vkt_proj)
reg_cyc_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_cyc_proj)
reg_walk_proj = (J(Time_length - VKT_time_length,Regions_n,0)\reg_walk_proj)
reg_active_proj = reg_cyc_proj + reg_walk_proj

cyc_tot = rowsum(reg_cyc_proj)
walk_tot = rowsum(reg_walk_proj)

cyc_percap_tot = cyc_tot:/pop
walk_percap_tot = walk_tot:/pop

/* NLTF adjustments*/
nltf_components_pre_adjust = nltf_components
/*values below are millions*/
ruc_per_lite_km = (J(Time_length - TL_fleet+1,1,0)\(lite_ruc_shr:*ruc[(Time_length - TL_fleet)+2..rows(ruc)]:/lite_diesel_vkt))
fed_per_lite_km = (J(Time_length - TL_fleet+1,1,0)\(lite_fed_shr:*fed[(Time_length - TL_fleet)+2..rows(fed)]:/lite_petrol_vkt))

swing_ruc = (J(Time_length - TL_fleet+1,1,0)\(lite_ruc_shr:*ruc[(Time_length - TL_fleet)+2..rows(ruc)]))
swing_fed = (J(Time_length - TL_fleet+1,1,0)\(lite_fed_shr:*fed[(Time_length - TL_fleet)+2..rows(fed)]))

fixed_ruc = ruc - swing_ruc
fixed_fed = fed - swing_fed

ruc_per_lite_km = (J(Time_length - TL_fleet+1,1,0)\(lite_ruc_shr:*ruc[(Time_length - TL_fleet)+2..rows(ruc)]):/lite_diesel_vkt)
fed_per_lite_km = (J(Time_length - TL_fleet+1,1,0)\(lite_fed_shr:*fed[(Time_length - TL_fleet)+2..rows(fed)]):/lite_fed_vkt)

swing_fed_proj = vkt_tot:*(J(Time_length - TL_fleet+1,1,0)\(lite_fed_shr)):*fed_per_lite_km
swing_ruc_proj = vkt_tot:*(J(Time_length - TL_fleet+1,1,0)\(1:-lite_fed_shr)):*ruc_per_lite_km

swing_fed_growth = swing_fed_proj[2..rows(swing_fed_proj)]:/swing_fed_proj[1..rows(swing_fed_proj)-1]
swing_ruc_growth = swing_ruc_proj[2..rows(swing_ruc_proj)]:/swing_ruc_proj[1..rows(swing_ruc_proj)-1]

for (i = IL_fiscal+1;i<=TL_fiscal;i++){
swing_ruc[i] = swing_ruc[i-1]:*(swing_ruc_growth[i-1])
swing_fed[i] = swing_fed[i-1]:*(swing_fed_growth[i-1])
}

ruc = fixed_ruc + swing_ruc
fed = fixed_fed + swing_fed
nltf  = mvr + ruc + fed
nltf_resid  = nltf - (mvr+fed+ruc)

nltf_components = (fed,ruc,mvr,nltf_resid)

fed_real = fed:/cpi_proj
ruc_real = ruc:/cpi_proj
mvr_real = mvr:/cpi_proj
nltf_real = nltf:/cpi_proj
nltf_real_resid = nltf_real - (mvr_real + fed_real + ruc_real)

nltf_real_components = (fed_real,ruc_real,mvr_real,nltf_real_resid)

local_revenue = local_tax:*reg_vkt_proj_re

/* PT subsidies*/
nzta_subsidy_proj = (J(8,12,0)\nzta_subsidy[1..20,.]\J(31,12,0))
lg_subsidy_proj = (J(8,12,0)\lg_subsidy\J(31,12,0))
for (i=22;i<=TL;i++){
nzta_subsidy_proj[i,.] = nzta_subsidy_proj[i-1,.]:*(reg_pt_passengers_proj[i,.]:/reg_pt_passengers_proj[i-1,.])
lg_subsidy_proj[i,.] = lg_subsidy_proj[i-1,.]:*(reg_pt_passengers_proj[i,.]:/reg_pt_passengers_proj[i-1,.])
}

tot_nzta_subsidy = rowsum(nzta_subsidy_proj):/1000000
tot_lg_subsidy = rowsum(lg_subsidy_proj):/1000000
tot_subsidy = (tot_nzta_subsidy + tot_lg_subsidy)


/* Net cashflow */
free_cashflow = nltf - tot_nzta_subsidy
net_nltf_real = free_cashflow:/cpi_proj

end



